"use client";
import { Button } from "@/components/ui/button";
import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from "@/components/ui/card";
import { Input } from "@/components/ui/input";
import { Label } from "@/components/ui/label";
import { useEffect, useState } from "react";
import { useAuth } from "@/context/AuthUserContext";
import ErrorAlert from "@/components/shared/alert/error-alert";
import SuccessAlert from "@/components/shared/alert/success-alert";
import { Loader2 } from "lucide-react";
import BackButton from "../shared/buttons/back-button";

export default function ForgotPassword() {
  const [error, setError] = useState(null);
  const [success, setSuccess] = useState(null);
  const { sendPasswordResetEmailHandler, loading } = useAuth();

  async function handleSubmit(event) {
    event.preventDefault();
    setError(null);
    setSuccess(null);
    const email = event.target.email.value;

    // Validate the email
    if (!email) {
      setError("Email is required");
      return;
    }

    try {
      await sendPasswordResetEmailHandler(email);
      setSuccess("Password reset email sent. Please check your inbox");
    } catch (error) {
      setError("An error occurred");
    }
  }

  if (success) {
    return (
      <div className="mx-auto max-w-sm grid gap-4">
        <SuccessAlert message={success} />
        <BackButton />
      </div>
    );
  }

  return (
    <Card className="mx-auto max-w-sm">
      <CardHeader>
        <CardTitle className="text-xl">Reset Password</CardTitle>
        <CardDescription>
          Enter your email to reset your password
        </CardDescription>
      </CardHeader>
      <CardContent>
        <form onSubmit={handleSubmit} className="grid gap-6">
          {error && <ErrorAlert message={error} />}
          <div className="grid gap-2">
            <Label htmlFor="email">Email</Label>
            <Input
              id="email"
              type="email"
              placeholder="m@example.com"
              required
            />
          </div>

          <Button type="submit" className="w-full" disabled={loading}>
            {loading && <Loader2 className="w-6 h-6 mr-2 animate-spin" />}
            <span>Submit</span>
          </Button>
        </form>
      </CardContent>
    </Card>
  );
}
